(*| 20:54  5/02/1994 *)
PROGRAM EGAFont;

USES Crt,StdTypes,EGAVars,EGAScreen,EGAWait,EGAUtils,EGADos,EGAEdit;

PROCEDURE WriteFont;
VAR
  S:LineString;
BEGIN
  Write('Save This Font, Y/N : ');
  IF YesKey THEN BEGIN
    Write(FontFileName,', File Name : ');
    Readln(S);
    IF Length(S) > 0 THEN
      FontFileName:=S;
    Writeln('Saving Font File ',FontFileName);
    ASSIGN(FontFile,FontFileName);
    REWRITE(FontFile,1);
    BlockWrite(FontFile,FontBuffer^,FontFileSize);
    CLOSE(FontFile);
  END;
  FontUpdated:=False;
END;  { WriteFont }

PROCEDURE ReadFont(FromParam: Boolean);
VAR
  I:Integer;
BEGIN
  IF ((ParamCount > 0) AND FromParam) THEN
    FontFileName:=ParamStr(1)
  ELSE BEGIN
    Write('Name of Font File : ');
    Readln(FontFileName);
  END;
  ASSIGN(FontFile,FontFileName);
{$I-}
  Reset(FontFile,1);
{$I+}
  IF IOResult=0 THEN
    BEGIN
      FontFileSize:=FileSize(FontFile);
      IF FontFileSize > $2000 THEN BEGIN
        Writeln('File ',FontFileName,' too large : ',FontFileSize);
        HALT;
      END;
      BlockRead(FontFile,FontBuffer^,FontFileSize);
      Close(FontFile);
    END
  ELSE BEGIN
    Writeln('Unable to find ',FontFileName,'. Initialising new.');
    PauseRdKey;
    FontFileSize:=14*256;
  END;
  BytesPerChar:=FontFileSize DIV 256;
  FontUpdated:=False;
  FontCharPtrs[0]:=Addr(FontBuffer^);
  FOR I:=1 TO MaxCharNum DO
    FontCharPtrs[I]:=IndexPtr(FontCharPtrs[0],(I*BytesPerChar));
END;  { ReadFont }

PROCEDURE ReadRom;
VAR
  FontNum: Integer;
BEGIN
  GotoXY(1,24);
  ClrEol;
  Write('Font Number, 2..7 : ');
  FontNum := GetNum(1,2,7,2);
  ReadRomFont(FontNum);
END;  { ReadRom }

PROCEDURE SwapFonts;
BEGIN
  IF FontNumber = 0 THEN BEGIN
    Font1FileName := FontFileName;
    Font1FileSize := FontFileSize;
    Font1CharPtrs := FontCharPtrs;
    Font1Updated  := FontUpdated;
    Font1Height   := BytesPerChar;
    FontBuffer    := Font2Buffer;
    ReadFont(False);
    Font2FileName := FontFileName;
    Font2FileSize := FontFileSize;
    Font2CharPtrs := FontCharPtrs;
    Font2Height   := BytesPerChar;
    FontNumber    := 2;
  END ELSE SwapOldFonts;
END;  { SwapFonts }

PROCEDURE TsrBin; EXTERNAL; {$L FONTROBJ.OBJ}

PROCEDURE LoadBin; EXTERNAL; {$L FONTOBJ.OBJ}

PROCEDURE Dummy; EXTERNAL; {$L DUMMYOBJ.OBJ}

PROCEDURE MakeLoadable;
VAR
  S,S2: LineString;
  MakeTSR: Boolean;
  P: Integer;
  TsrBinPtr,LoadBinPtr,DummyPtr: ^Byte;
  TsrBinLen,LoadBinLen: Integer;
BEGIN
  Write('Make TSR Y/N ? : ');
  MakeTSR := YesKey;
  IF MakeTsr THEN
    Write('Y.  ')
  ELSE
    Write('N.  ');
  Write(FontFileName,', File Name : ');
  Readln(S);
  IF Length(S) = 0 THEN
    S:=FontFileName;
  P:=POS('.',S);
  IF P > 1 THEN
    S:=COPY(S,1,P-1);
  S:=S+'.COM';
  Writeln('Saving Font File ',S);
  TsrBinPtr := Addr(TsrBin);
  LoadBinPtr := Addr(LoadBin);
  DummyPtr := Addr(Dummy);
  TsrBinLen := Ofs(LoadBinPtr^) -Ofs(TsrBinPtr^);
  LoadBinLen := Ofs(DummyPtr^) -Ofs(LoadBinPtr^);
  ASSIGN(FontFile,S);
  REWRITE(FontFile,1);
  IF MakeTSR THEN
    BlockWrite(FontFile,TsrBinPtr^,TsrBinLen)
  ELSE
    BlockWrite(FontFile,LoadBinPtr^,LoadBinLen);
  BlockWrite(FontFile,FontBuffer^,FontFileSize);
  CLOSE(FontFile);
END;  { MakeLoadable }

PROCEDURE EditFont;
VAR
  Exit: Boolean;
  Key:Char;
  KeyFunc: KeyType;
BEGIN
  Exit:=False;
  REPEAT
    ClrScr;
    Heading;
    GotoXY(35,3);
    Write('Main Menu');
    GotoXY(30,5);
    Write('1  Character');
    GotoXY(30,7);
    Write('2  Write');
    GotoXY(30,9);
    Write('3  Quit to DOS');
    GotoXY(30,11);
    Write('4  Read');
    GotoXY(30,13);
    Write('5  Enlarge');
    GotoXY(30,15);
    Write('6  Shrink');
    GotoXY(30,17);
    Write('7  Double Height');
    GotoXY(30,19);
    Write('8  Font from Rom');
    GotoXY(30,21);
    Write('9  Swap Fonts');
    GotoXY(30,23);
    IF BytesPerChar = 16 THEN
      Write('0  Make Loadable');
    GotoXY(1,24);
    WaitKey(Key,KeyFunc);
    IF KeyFunc = Normal THEN
      Case(UpCase(Key)) OF
        '1','C' : EditChar;
        '2','W' : WriteFont;
        '3','Q' : Exit:=True;
        '4','R' : BEGIN
                    IF FontUpdated THEN WriteFont;
                    ReadFont(False);
                  END;
        '5','E' : ExpandFont;
        '6','S' : ShrinkFont;
        '7','D' : DoubleHeight;
        '8','F' : ReadRom;
        '9'     : SwapFonts;
        '0','M' : IF BytesPerChar = 16 THEN
                    MakeLoadable;
      END
    ELSE
      CASE KeyFunc OF
        ESC : Exit:=True;
      END;
  UNTIL Exit;
END;  { EditFont }

BEGIN
  InitScreen;
  ProgramTitle:='EGAFont V1.2  ';
  Writeln('EGA Font Editor by B Whitnall. V1.2 February 1990');
  Writeln;
  ReadFont(True);
  EditFont;
  IF FontUpdated THEN WriteFont;
  FreeMem(FontBuffer,MaxFontFileSize);
END.
